function [t,q,dq,ddq]=motion_definition_min_jerk(specs,qini,qd,tf,dt)

%cette fonction renvoie les tableaux t, q dq et ddq contenant chacun
%l'volution de ces quantits au cours du temps. La fonction prend en
%entre specs, qui contient les paramtres du modle, qini, qui contient
%les coordonnes articulaires initales, qd les coordonnes articulaires
%finales, tf le temps de parcours et dt le pas de temps de simulation

%% initialisation des sorties de la fonction
t=0:dt:tf;
q=zeros(2,numel(t));
dq=zeros(2,numel(t));
ddq=zeros(2,numel(t));

% variable intermdiaire contenant la trajectoire de O2 ( calculer
% ensuite)
X=zeros(2,numel(t));
%% TODO

%1. Tout d'abord,  l'aide de la fonction DK_bras_plan, calculer les
%positions initiales Xini et finales Xd de O2  l'aide de qini et qd 
%2. Ensuite, crire une boucle permettant d'obtenir  partir des positions
%finales et initiales la position de O2 X  tout instant,  l'aide des
%quations donnes dans le sujet.




%% Cette boucle permet de calculer les coordonnes articulaires associes au mouvement dfini ci-dessus et de les driver.
% C'est ce qu'on appelle communment l'tape de cinmatique inverse

for i=2:numel(t)

q(2,i)=acos((X(1,i)^2+X(2,i)^2-specs.l1^2-specs.l2^2)/(2*specs.l1*specs.l2));
q(1,i)=atan(X(2,i)/X(1,i))-atan((specs.l2*sin(q(2,i)))/(specs.l1+specs.l2*cos(q(2,i))));

end

dq=derivate_2order(dt,q')';
ddq=derivate_2order(dt,dq')';

end